using System;
using System.Collections.Generic;
using System.Linq;

class Point {
    public int idx;
    public double x, y;
    public Point(int idx, double x, double y){ this.idx=idx; this.x=x; this.y=y;}
}

class Edge : IComparable<Edge> {
    public int u,v;
    public double w;
    public Edge(int u,int v,double w){ this.u=u; this.v=v; this.w=w;}
    public int CompareTo(Edge other){ return w.CompareTo(other.w);}
}

class Program {
    static int Find(int[] par, int x){ return par[x]==x ? x : (par[x]=Find(par, par[x]));}
    static bool Union(int[] par, int x, int y){
        int px = Find(par,x), py = Find(par,y);
        if(px==py) return false;
        par[px]=py; return true;
    }

    static void Main(){
        var first = Console.ReadLine().Split();
        int n = int.Parse(first[0]);
        double eps = double.Parse(first[1]);

        var points = new List<Point>();
        for(int i=0;i<n;i++){
            var xy = Console.ReadLine().Split().Select(double.Parse).ToArray();
            points.Add(new Point(i+1, xy[0], xy[1]));
        }

        // grid cell selection
        var selected = new List<Point>();
        var used = new Dictionary<(int,int),bool>();
        foreach(var p in points){
            int cx = (int)(p.x/eps);
            int cy = (int)(p.y/eps);
            if(!used.ContainsKey((cx,cy))){
                used[(cx,cy)] = true;
                selected.Add(p);
            }
        }

        // build MST on selected points (Kruskal)
        int m = selected.Count;
        var edges = new List<Edge>();
        for(int i=0;i<m;i++)
            for(int j=i+1;j<m;j++){
                double w = Math.Abs(selected[i].x - selected[j].x) + Math.Abs(selected[i].y - selected[j].y);
                edges.Add(new Edge(i,j,w));
            }
        edges.Sort();

        int[] par = new int[m]; for(int i=0;i<m;i++) par[i]=i;
        var mstEdges = new List<(int,int)>();
        foreach(var e in edges){
            if(Union(par,e.u,e.v)){
                mstEdges.Add((selected[e.u].idx, selected[e.v].idx));
                if(mstEdges.Count==m-1) break;
            }
        }

        Console.WriteLine(m);
        Console.WriteLine(string.Join(" ", selected.Select(p=>p.idx)));
        foreach(var e in mstEdges) Console.WriteLine($"{e.Item1} {e.Item2}");
    }
}